--- #18294  tlog.Auditlog configurieren
CREATE TABLE tlog.AuditlogConfig_ON (                            --- master-Tabelle
  lon_table                     varchar(100)  PRIMARY KEY,
  lon_stamp                     TIMESTAMP(0) NOT NULL DEFAULT currenttime(),  -- [SYNCRO:SyncID]
  lon_log_insert                bool NOT null DEFAULT false,
  lon_log_update                bool NOT null DEFAULT true,
  lon_log_delete                bool NOT null DEFAULT true,
  lon_trigger_script            text,
  lon_code_ident                text,
  lon_when                      varchar,
  lon_parent_fname              varchar(63),                             --- FUNCTION tlog.Auditlog_parent_fname
  lon_code_references__get      text,
  lon_modified                  timestamp(0)  DEFAULT currenttime(),     --- [SYNCRO:Modified]
  lon_localmodified             boolean       DEFAULT false,             --- [SYNCRO:NotThisFields]
  lon_inaktiv                   boolean,
  lon_code_ident_json           text
 );

--- #21518  Datensatz in der Tabelle tlog.auditlogconfig_on nicht löschen zulassen
CREATE OR REPLACE FUNCTION tlog.auditlogconfig_on__b_d__no_delete() RETURNS TRIGGER AS $$
  BEGIN

    -- versehentliches Löschen in Oberfläche verhindern. Nur möglich wenn man wirklich den Trigger zuvor deaktiviert.
    raise exception 'auditlogconfig: Datensatz darf nicht gelöscht werden! Trigger "auditlogconfig_on__b_d__no_delete" deaktivieren, wenn wirklich gelöscht werden soll!';

    RETURN old;
  END $$ LANGUAGE plpgsql;

CREATE TRIGGER auditlogconfig_on__b_d__no_delete
  BEFORE DELETE
  ON tlog.auditlogconfig_on
  FOR EACH ROW
  EXECUTE PROCEDURE tlog.auditlogconfig_on__b_d__no_delete();

CREATE TABLE tlog.AuditlogConfig_OF (                                         --- child-Tabelle
  lof_stamp                     TIMESTAMP(0) NOT NULL DEFAULT currenttime(),  --- [SYNCRO:SyncID]
  lof_table                     varchar(100) REFERENCES tlog.AuditlogConfig_ON ON DELETE CASCADE,
  lof_fieldname                 varchar(63)  NOT null,
  lof_logging                   bool         NOT null DEFAULT true,
  lof_modified                  timestamp(0) DEFAULT currenttime(),            --- [SYNCRO:Modified]
  lof_localmodified             boolean      DEFAULT false                     --- [SYNCRO:NotThisFields]
 );

CREATE UNIQUE INDEX AuditlogConfig_OF_index ON tlog.AuditlogConfig_OF( lof_table, lof_fieldname );
---
CREATE OR REPLACE FUNCTION tlog.auditlogconfig_on__a_99_i__insert__auditlogconfig_of() RETURNS TRIGGER AS $$
  BEGIN

    PERFORM tlog.AuditlogConfig_OF__create__by__lof_table( new.lon_table );

    RETURN new;
  END $$ LANGUAGE plpgsql;

CREATE TRIGGER auditlogconfig_on__a_99_i__insert__auditlogconfig_of
  AFTER INSERT
  ON tlog.auditlogconfig_on
  FOR EACH ROW
  EXECUTE PROCEDURE tlog.auditlogconfig_on__a_99_i__insert__auditlogconfig_of();
---
CREATE OR REPLACE FUNCTION tlog.auditlogconfig_on__a_99_u__lon_trigger_script() RETURNS TRIGGER AS $$
  BEGIN

    UPDATE tlog.auditlogconfig_on SET lon_trigger_script = ( SELECT tlog.auditlog__table_trigger__from__AuditlogConfig_ON__create__txt( new.lon_table ) ) WHERE lon_table = new.lon_table;

    RETURN new;
  END $$ LANGUAGE plpgsql;

CREATE TRIGGER auditlogconfig_on__a_99_u__lon_trigger_script
  AFTER UPDATE
  OF lon_log_insert, lon_log_update, lon_log_delete, lon_when
  ON tlog.auditlogconfig_on
  FOR EACH ROW
  EXECUTE PROCEDURE tlog.auditlogconfig_on__a_99_u__lon_trigger_script();
---
CREATE OR REPLACE FUNCTION tlog.auditlogconfig_of__a_99_u__lon_trigger_script() RETURNS TRIGGER AS $$
  BEGIN

    UPDATE tlog.auditlogconfig_on SET lon_trigger_script = ( SELECT tlog.auditlog__table_trigger__from__AuditlogConfig_ON__create__txt( new.lof_table ) ) WHERE lon_table = new.lof_table;

    RETURN new;
  END $$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS auditlogconfig_of__a_99_u__lon_trigger_script ON tlog.auditlogconfig_of;
CREATE TRIGGER auditlogconfig_of__a_99_u__lon_trigger_script
  AFTER UPDATE
  ON tlog.auditlogconfig_of
  FOR EACH ROW
  EXECUTE PROCEDURE tlog.auditlogconfig_of__a_99_u__lon_trigger_script();
---

--- Funktion erstellt AuditlogConfig_OF neue von aktueller Tabellestruktur-Stand
CREATE OR REPLACE FUNCTION tlog.AuditlogConfig_OF__all__recreate() RETURNS void AS $$
  DECLARE rec   record;

 BEGIN

    FOR rec IN SELECT lon_table FROM tlog.AuditlogConfig_ON LOOP

        PERFORM tlog.AuditlogConfig_OF__create__by__lof_table( trim( rec.lon_table ) );

    END LOOP;

 END $$ LANGUAGE plpgsql;
---